/**
* \file: DevelopersAuthenticator.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2015 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#include <adit_logging.h>
#include "DevelopersAuthenticator.h"

using namespace std;

LOG_IMPORT_CONTEXT(aauto_authentication)

namespace adit { namespace aauto {

DevelopersAuthenticator::DevelopersAuthenticator() {}

DevelopersAuthenticator::~DevelopersAuthenticator() {}

bool DevelopersAuthenticator::setCertificates(shared_ptr<GalReceiver> inReceiver)
{
    bool result = false;

    if (inReceiver == nullptr)
        return result;

    string rootCert = getRootCert();
    string clientCert = getClientCert();
    string privateKey = getPrivateKey();

    result = inReceiver->setClientCreds(rootCert, clientCert, privateKey);

    /* overwrite the stack/heap */
    memset((void*)rootCert.data(), 0, rootCert.length());
    memset((void*)clientCert.data(), 0, clientCert.length());
    memset((void*)privateKey.data(), 0, privateKey.length());

    /* necessary to avoid that the compiler removes the memset operation above */
    asm volatile("" ::: "memory");

    return result;
}

void DevelopersAuthenticator::setConfigItem(std::string inKey, std::string inValue) {}

string DevelopersAuthenticator::getRootCert()
{
    /* PRQA: Lint Message 99: Non-standard syntax: Letter i used as integer suffix */
    /*lint -save -e99 */
    return "-----BEGIN CERTIFICATE-----\n"
            "MIIDiTCCAnGgAwIBAgIJAMFO56WkVE1CMA0GCSqGSIb3DQEBBQUAMFsxCzAJBgNV\n"
            "BAYTAlVTMRMwEQYDVQQIDApDYWxpZm9ybmlhMRYwFAYDVQQHDA1Nb3VudGFpbiBW\n"
            "aWV3MR8wHQYDVQQKDBZHb29nbGUgQXV0b21vdGl2ZSBMaW5rMB4XDTE0MDYwNjE4\n"
            "MjgxOVoXDTQ0MDYwNTE4MjgxOVowWzELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNh\n"
            "bGlmb3JuaWExFjAUBgNVBAcMDU1vdW50YWluIFZpZXcxHzAdBgNVBAoMFkdvb2ds\n"
            "ZSBBdXRvbW90aXZlIExpbmswggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB\n"
            "AQDUH+iIbwwVb74NdI5eBv/ACFmh4ml/NOW7gUVWdYX50n8uQQsHHLCNIhk5VV2H\n"
            "hanvAZ/XXHPuVAPadE2HpnNqePKF/RDo4eJo/+rOief8gBYq/Z+OQTZeLdNm+GoI\n"
            "HBrEjU4Ms8IdLuFW0jF8LlIRgekjLHpc7duUl3QpwBlmAWQK40T/SZjprlmhyqfJ\n"
            "g1rxFdnGbrSibmCsTmb3m6WZyZUyrcwmd7t6q3pHbMABO+o02asPG/YPj/SJo4+i\n"
            "fb5/Nk56f3hH9pBiPKQXJnVUdVLKMXSRgydDBsGSBol4C0JL77MNDrMR5jdafJ4j\n"
            "mWmsa2+mnzoAv9AxEL9T0LiNAgMBAAGjUDBOMB0GA1UdDgQWBBS5dqvv8DPQiwrM\n"
            "fgn8xKR91k7wgjAfBgNVHSMEGDAWgBS5dqvv8DPQiwrMfgn8xKR91k7wgjAMBgNV\n"
            "HRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQDKcnBsrbB0Jbz2VGJKP2lwYB6P\n"
            "dCTCCpQu7dVp61UQOX+zWfd2hnNMnLs/r1xPO+eyN0vmw7sD05phaIhbXVauKWZi\n"
            "9WqWHTaR+9s6CTyBOc1Mye0DMj+4vHt+WLmf0lYjkYUVYvR1EImX8ktXzkVmOqn+\n"
            "e30siqlZ8pQpsOgegIKfJ+pNQM8c3eXVv3KFMUgjZW33SziZL8IMsLvSO+1LtH37\n"
            "KqbTEMP6XUwVuZopgGvaHU74eT/WSRGlL7vX4OL5/UXXP4qsGH2Zp7uQlErv4H9j\n"
            "kMs37UL1vGb4M8RM7Eyu9/RulepSmqZUF+3i+3eby8iGq/3OWk9wgJf7AXnx\n"
            "-----END CERTIFICATE-----\n";
    /*lint -restore */
}

string DevelopersAuthenticator::getClientCert()
{
    return "-----BEGIN CERTIFICATE-----\n"
            "MIIDIzCCAgsCAl8HMA0GCSqGSIb3DQEBCwUAMFsxCzAJBgNVBAYTAlVTMRMwEQYD\n"
            "VQQIDApDYWxpZm9ybmlhMRYwFAYDVQQHDA1Nb3VudGFpbiBWaWV3MR8wHQYDVQQK\n"
            "DBZHb29nbGUgQXV0b21vdGl2ZSBMaW5rMB4XDTE0MDgxMjIxMTM0MloXDTQ0MDgx\n"
            "MTIxMTM0MlowUzELMAkGA1UEBhMCVVMxCzAJBgNVBAgMAkNBMRYwFAYDVQQHDA1N\n"
            "b3VudGFpbiBWaWV3MR8wHQYDVQQKDBZHb29nbGUtTGludXgtUmVmZXJlbmNlMIIB\n"
            "IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAm8nbg+Fu/L0l8VA5cqryS3/h\n"
            "hMCzkz6Lwp9dO+1S4xQ3kv2//m8OHpeZ41PqBHoyox1PG2xoCMu56w2k0LISBjTW\n"
            "NRP/nl8svzUcaGijWClbRUCnDgANP8roNd62CZ3Dt17ovbPKV6S3oLYxbQu+wVaM\n"
            "G1rIiFl3ppOuOodNcLG7Swm1eh2BEd47kOZW+XRZnu58/cPvLG3KZwbiUyY4YEB9\n"
            "OsMTnBB+C1dDzwIB7Xl2jXut40Z6E1M9Li+3SxOYRDGH+ZvFWMp/iP9oyb8BEMvi\n"
            "lEOBwlc6G5q6shhNxXPXnDPuGOWAmbkvHOXZ/rR61ZVJ9gphSu8TJZywEhWs8wID\n"
            "AQABMA0GCSqGSIb3DQEBCwUAA4IBAQAP53S7ezbnyQzync8E7AyYMpt/9GDAqeZD\n"
            "f8QJnchZFcao7K06AxyGgz3+T4Od50YZgGlwTp1O1h5uApry2PU/lIg0Mlhx1VgA\n"
            "coLcewRiDmxawMrzQLCOluDidw41NOMw8Swi76Cl0tcJDB+LqKc3hcJeHuzgpsXd\n"
            "mEHgHlHSLrMAWFsb2ZcZVFEPQfTsSd9f9zjcWlKDWZG+NzkOqJ4umiUTic7dG/ZQ\n"
            "FYW+fly5ETi1bkiVLOpmynzwSCFq+QyLG1y76kQEr5ShlxJMgPNh+qf9LMk9+2D0\n"
            "vKKqgpFfBM5WHfAdh0v0cKHu1WLesNCKG8AFwecpYZ0PkuqxxfhH\n"
            "-----END CERTIFICATE-----\n";
}

string DevelopersAuthenticator::getPrivateKey()
{
    /* PRQA: Lint Message 146: Not a binary constant, an inalterable string */
    /*lint -save -e146 */
    /* PRQA: Lint Message 99: Non-standard syntax: Letter i used as integer suffix */
    /*lint -save -e99 */
    return "-----BEGIN PRIVATE KEY-----\n"
            "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCbyduD4W78vSXx\n"
            "UDlyqvJLf+GEwLOTPovCn1077VLjFDeS/b/+bw4el5njU+oEejKjHU8bbGgIy7nr\n"
            "DaTQshIGNNY1E/+eXyy/NRxoaKNYKVtFQKcOAA0/yug13rYJncO3Xui9s8pXpLeg\n"
            "tjFtC77BVowbWsiIWXemk646h01wsbtLCbV6HYER3juQ5lb5dFme7nz9w+8sbcpn\n"
            "BuJTJjhgQH06wxOcEH4LV0PPAgHteXaNe63jRnoTUz0uL7dLE5hEMYf5m8VYyn+I\n"
            "/2jJvwEQy+KUQ4HCVzobmrqyGE3Fc9ecM+4Y5YCZuS8c5dn+tHrVlUn2CmFK7xMl\n"
            "nLASFazzAgMBAAECggEAY3op6bRxooFFUSnhBQ+TWBJ4dsR15nfx1nzck/+fBdFL\n"
            "C1ls15MiePZlFXvn2qQM4Ys9kE1QwQ0V0roLnBeY2s2yWoJCn2Y2tIG9eg4W/5yo\n"
            "4ze9dHsj+rAeRwfHRayv5M993mSHuB8+AilUtkThsaMKJA18L1SxynRStJzhHivg\n"
            "SKVxP/eljyFL4R0Tr5QWV3Fw0eAtDdbrwgYfvbPg6J4bMCnfa8uNuzxIy6iiIK0n\n"
            "bemkQMk6gZnGPV7okIoWeRjCOyBdKGJfB3TPZOlkIxUo4E5I7t209HknselSEXxr\n"
            "sJ6tD3kuil4nmzNdnmeXF++ieyAA9hUJs5aSZXd5AQKBgQDMVs5EbJfAes1fjJxl\n"
            "+oyyWN/3yp3zHQVKwi+8IFtg9fZFdRGq69lQQYvC+IJcZEaZMFPwiCJjAtUL1c6S\n"
            "0bXpCHK/S8f11m4Trz47hmNTIQN6DwkylxB71SGCX3VSvGAbYmYoRMZg06hxXRaj\n"
            "5MHyTameOIu96jOkANZJBe5ucQKBgQDDLMVKjby52BBaBR1tLKoNSjfGOC7ZX+N4\n"
            "+3/6X+RY4V1UaYKHJIZ/6lO5jv1u9f6Y4SMgS72Xdo21GCPVov8wdjtpRen6bJYG\n"
            "rra1/Pqgf/+J0IBI0wwwVrua0Xr5HBMdx4RH0mtiHQBVpc37m8AwvLvLMO03Iu82\n"
            "hHL5TS6LowKBgGjQqjOdBGZ+V3SIuvzwfVVKk3AWpdi77SgA3d2BN35QDIhqWaq0\n"
            "Gh+5z4guUygzY6dWi+gY3JKvNDtC7BiRq98iL0IDDEoFOSetv51m/PH6QD9PESe7\n"
            "J4BtvieS8aqD6ESDv+UuChhG2eN0nZVqVTYGMlhvpva++MhKiaChg0FxAoGBAJaE\n"
            "uopqkLeKZ+Hku/LsVSD2sdjOj2LYzmcJHoOK3GGnPADTdfSfOJMBthwOqGigkf54\n"
            "8kv/3XEn3tVgjpI9qCxJojvnzTBx+amhqArl1Ktey0YPZD/Fc0r8OKaHEx12h0+a\n"
            "BOwW3PXHg/CJdDeswCVWCEYFr4usB2u17a1R1qmdAoGACUNC/5XGxkO5uBdPmSpf\n"
            "ePx48Hkgy00tToAb4lDWZHqvlpY1RgHjw1JV549VLm1bTEKmT+CIc7EdgsaSY9GQ\n"
            "TKmCA9sCFVQwHQB7Q1O94OA9XPsmHxHjc8Q4cnYspndAMZfjfrwEyhvNHFjznZNr\n"
            "b7Zk+HzSX6mpkkdUlFwCUMg=\n"
            "-----END PRIVATE KEY-----\n";
    /*lint -restore */
    /*lint -restore */
}

} } /* namespace adit { namespace aauto { */
